/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWApplicationSpace;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWAttachmentTrackingQuery;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCreateLiveWOResult;
import filenet.vw.api.VWEnvironmentDataList;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWLog;
import filenet.vw.api.VWMilestoneElement;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWParticipantList;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWRole;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRosterElement;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.api.VWSecurityDomain;
import filenet.vw.api.VWSecurityList;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWSystemAdministration;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWUserInfo;
import filenet.vw.api.VWWorkObject;
import filenet.vw.api.VWWorkObjectNumber;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.UserContextInfo;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWConvertTwo;
import filenet.vw.base.VWLocale;
import filenet.vw.base.VWMailAuthenticator;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.VWTimerLog;
import filenet.vw.server.Configuration;
import filenet.vw.server.IPECommands;
import filenet.vw.server.PECommandsFactory;
import filenet.vw.server.VWBootstrapURL;
import filenet.vw.server.VWCommandSession;
import filenet.vw.server.VWConfigInfo;
import filenet.vw.server.VWConfigResult;
import filenet.vw.server.VWEnvironmentData;
import filenet.vw.server.VWField;
import filenet.vw.server.VWNoOnlineClassesException;
import filenet.vw.server.VWQueryResults;
import filenet.vw.soap.VWSOAPRouterURL;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Authenticator;
import javax.mail.Session;

public final class VWSession
implements Serializable {
    private static final long serialVersionUID = 119619L;
    private static final String m_className = "VWSession";
    protected String serviceName;
    protected String m_originalCPName;
    protected int isolatedRegion;
    protected String auditFile;
    protected boolean auditOn = false;
    protected String userName;
    protected String pw;
    protected VWUserInfo userInfo = null;
    protected int numServers = -1;
    protected int webAppId = 0;
    protected String[] queueNameCache;
    protected String[] rosterNameCache;
    protected IPECommands cmdSession = null;
    protected static final int BUFFERSIZE = 2000000;
    protected static final String lpar = "(";
    protected static final String rpar = ")";
    private static Logger logger = Logger.getLogger("filenet.vw.api");
    private static final int USER_NONE = 0;
    private static final int USER_ANYONE = 1;
    private static final int USER_UNDEFINED = 6;
    private static final int USER_SERVICE_PROCESS = 5;
    private static final int USER_USER_DEFAULTS = 7;
    private static final int USER_GROUP_DEFAULTS = 8;
    private static final int USER_DEVICE_DEFAULTS = 9;
    private static final int USER_SYSTEM_DEFAULTS = 10;
    private static final int USER_SERVPROCTERM = 14;
    private static final String USTR_NONE = "(NONE)";
    private static final String USTR_ANYONE = "(ANYONE)";
    private static final String USTR_SERVICE = "ServiceProcess:System:System";
    private static final String USTR_INTERNAL_USER = "(INTERNAL USER)";
    protected String NCHServerName = null;
    protected String NCHServerDomain = null;
    protected String NCHServerOrganization = null;
    protected static final String DELIM = ":";
    protected transient VWSecurityList secList = null;
    protected transient VWEnvironmentDataList envDataList = null;
    protected transient Hashtable participantHashtable = null;
    public static final int QUEUE_PROCESS = 1;
    public static final int QUEUE_USER_CENTRIC = 2;
    public static final int QUEUE_SYSTEM = 4;
    public static final int QUEUE_IGNORE_SECURITY = 16;
    public static final int QUEUE_USER_CENTRIC_FOR_USER_ONLY = 32;
    public static final int PRODUCT_PW = 1;
    public static final int PRODUCT_BPS = 2;
    public static final int PRODUCT_OPEN_CLIENT = 4;
    public static final int PRODUCT_CUSTOM = 8;
    public static final int WEBAPP_NONE = 0;
    public static final int WEBAPP_WORKPLACE = 1;
    public static final int WEBAPP_WEB_WORKFLO = 2;
    public static final int WEBAPP_OPEN_CLIENT = 3;
    public static final int WEBAPP_COLLABORATION = 4;
    public static final int WEBAPP_WCM = 5;
    public static final int WEBAPP_RECORDS_MANAGER = 6;
    public static final int WEBAPP_WORKPLACE_XT = 7;
    public static final int WEBAPP_ECM_WIDGETS_LOTUS_MASHUPS = 8;
    public static final int WEBAPP_ECM_WIDGETS_BUSINESS_SPACE = 9;
    public static final int WEBAPP_CONTENT_NAVIGATOR = 10;
    public static final int WEBAPP_CUSTOM = 100;
    public static final int DATABASE_ORACLE = 1;
    public static final int DATABASE_SQL2000 = 2;
    public static final int DATABASE_DB2 = 3;
    protected static final int DATABASE_SQL2000_INT = 4;
    protected static final int DATABASE_DB2_INT = 5;
    public static final int DATABASE_SQL2000ODBC = 6;
    public static final int ATTRIBUTES_SYSTEM = 1;
    public static final int ATTRIBUTES_REGION = 2;
    public static final int DS_TYPE_SEC = 0;
    public static final int DS_TYPE_LDAP = 1;
    public static final int MILESTONE_QUERY_WORKOBJECT_NUMBER = 0;
    public static final int MILESTONE_QUERY_WORKFLOW_NUMBER = 1;
    public static final int SEARCH_TYPE_NONE = 0;
    public static final int SEARCH_TYPE_CUSTOM = 1;
    public static final int SEARCH_TYPE_PREFIX_MATCH = 2;
    public static final int SEARCH_TYPE_SUFFIX_MATCH = 3;
    public static final int SEARCH_TYPE_CONTAINS = 4;
    public static final int SORT_TYPE_NONE = 0;
    public static final int SORT_TYPE_ASCENDING = 1;
    public static final int SORT_TYPE_DESCENDING = 2;
    public static final int SERVER_FILE_SCHEMA = 1;
    public static final int SERVER_FILE_TRANSFORM = 2;
    public static final int ALL_WORKFLOW_SIGNATURES = 0;
    public static final int RECEIVE_WORKFLOW_SIGNATURES = 1;
    public static final int PARTNERLINK_SIGNATURES = 2;
    public static final int PRIVILEGES_ADMINISTRATOR = 1;
    public static final int PRIVILEGES_CONFIGURATION = 2;
    public static final int ACCESS_READ_APPLICATIONSPACE = 0;
    public static final int ACCESS_WRITE_APPLICATIONSPACE = 1;
    public static final int ACCESS_IGNORE_APPLICATIONSPACE_SECURITY = 2;
    public static final int APPLICATIONSPACE_ONLY = 0;
    public static final int APPLICATIONSPACE_INCLUDING_ROLES = 1;
    public static final int APPLICATIONSPACE_INCLUDING_ROLE_MEMBERS = 2;
    protected static final boolean DUMP_XML_FROM_SERVER = false;
    private static final int UNASSIGNED_USER_ID = 9;
    private static final int KEY_MASK = 0;
    protected transient String objectStoreSymbolicName = null;
    protected VWGuid objectStoreId = null;
    private String m_bootstrapCEURI = null;
    private InputStream m_bootstrapConfigStream = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-10-13 00:20:58 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Van Vuong;5D6184897;vanvuong1@us.ibm.com (vvuong) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/32 $";
    }

    public VWSession() {
    }

    public VWSession(String url) throws VWException {
        this.logon(url);
    }

    public VWSession(String user, String password, String connectionPointName) throws VWException {
        this.logon(user, password, connectionPointName);
    }

    public VWSession(String domain, String user, String password, String connectionPointName) throws VWException {
        this.logonByDomain(domain, user, password, connectionPointName);
    }

    public void logon(String user, String password, String connectionPointName) throws VWException {
        this.logonByDomain(null, user, password, connectionPointName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logon(String url) throws VWException {
        String m_method = "logon(viaUrl):" + url;
        VWTimerLog timer = new VWTimerLog(m_method);
        try {
            this.m_originalCPName = url;
            if (url == null) {
                throw new VWException("vw.api.SConnectionPointNull", "The connection point name is null. ");
            }
            url = this.formulateURLForBootstrap(url);
            this.cmdSession = PECommandsFactory.getPECommandsFromURL(url);
            this.userName = this.cmdSession.getUserName();
            this.isolatedRegion = this.cmdSession.getIsolatedRegion();
            this.serviceName = url;
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "logon(viaUrl) -- " + this.userName + ", m_originalCPName=" + this.m_originalCPName + ", serviceName=" + this.serviceName + ",region=" + Integer.toString(this.isolatedRegion) + ", url=" + url);
            }
        }
        finally {
            timer.stop();
        }
    }

    public void logonByDomain(String domain, String user, String password, String connectionPointName) throws VWException {
        this.logonByDomain(domain, user, password, connectionPointName, 65537L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logonByDomain(String domain, String user, String password, String connectionPointName, long argFlag) throws VWException {
        this.m_originalCPName = connectionPointName;
        String m_method = "logonByDomain:" + user + DELIM + this.m_originalCPName;
        VWTimerLog timer = new VWTimerLog(m_method);
        try {
            this.userName = user;
            this.pw = password;
            if (logger.isFinest() && (password == null || password.length() == 0)) {
                Exception ex = new Exception("VWSession.logon called with empty password!!");
                logger.throwing(m_className, m_method, ex);
            }
            if (connectionPointName == null) {
                throw new VWException("vw.api.SConnectionPointNull", "The connection point name is null. ");
            }
            connectionPointName = this.formulateURLForBootstrap(connectionPointName);
            this.cmdSession = PECommandsFactory.getPECommands(domain, user, password, connectionPointName);
            this.userName = this.cmdSession.getUserName();
            this.isolatedRegion = this.cmdSession.getIsolatedRegion();
            this.serviceName = VWCommandSession.serviceDestination(connectionPointName);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "logon -- " + this.userName + ", m_originalCPName=" + this.m_originalCPName + ", serviceName=" + this.serviceName + ",region=" + Integer.toString(this.isolatedRegion) + ",full url=" + connectionPointName);
            }
        }
        finally {
            timer.stop();
        }
    }

    public void logonWithToken(String theToken, String connectionPointName) throws VWException {
        String m_method = "logonWithToken:" + connectionPointName;
        if (theToken == null) {
            throw new VWException("vw.api.nullToken", "The token is null.  Unified Logon is no longer supported.");
        }
        this.m_originalCPName = connectionPointName;
        connectionPointName = this.formulateURLForBootstrap(connectionPointName);
        this.cmdSession = PECommandsFactory.getPECommands(null, theToken, null, connectionPointName);
        this.userName = this.cmdSession.getUserName();
        this.isolatedRegion = this.cmdSession.getIsolatedRegion();
        this.serviceName = VWCommandSession.serviceDestination(connectionPointName);
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "logon -- " + this.userName + ", m_originalCPName=" + this.m_originalCPName + ", serviceName=" + this.serviceName + ",region=" + Integer.toString(this.isolatedRegion) + ", url=" + connectionPointName);
        }
    }

    public VWRoster getRoster(String rosterName) throws VWException {
        if (rosterName == null) {
            throw new VWException("vw.api.SRosterNameNull", "The roster name is null.");
        }
        this.checkSession();
        boolean found = false;
        int trycount = 0;
        block0: while (!found && trycount < 2) {
            int i;
            if (this.rosterNameCache == null || trycount == 1) {
                this.rosterNameCache = this.getRosterNames();
            }
            ++trycount;
            for (i = 0; i < this.rosterNameCache.length; ++i) {
                if (!rosterName.equals(this.rosterNameCache[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            for (i = 0; i < this.rosterNameCache.length; ++i) {
                if (!rosterName.equals(this.translate(this.rosterNameCache[i]))) continue;
                found = true;
                continue block0;
            }
        }
        if (!found) {
            throw new VWException("vw.api.SRosterNameInvalid", "The roster name {0} is not valid for this session.", rosterName);
        }
        VWRoster rosterSession = new VWRoster(this.translateToAuthored(rosterName), this);
        rosterSession.setConfigInfo(this.findConfig(rosterName, false));
        return rosterSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWQueue getQueue(String queueName) throws VWException {
        if (queueName == null || queueName.length() == 0) {
            throw new VWException("vw.api.SQueueNameNull", "The queue name is null or empty.");
        }
        String m_method = "getQueue:" + queueName;
        logger.entering(m_className, m_method);
        try {
            this.checkSession();
            int queueType = 0;
            int queueServer = 0;
            VWConfigInfo queueConfig = null;
            boolean found = false;
            int serverId = 0;
            int trycount = 0;
            boolean isConnectorQueue = false;
            block3: while (!found && trycount < 2) {
                if (this.queueNameCache == null || trycount == 1) {
                    this.queueNameCache = this.cmdSession.getQueueNames(true, false);
                }
                ++trycount;
                for (int i = 0; i < this.queueNameCache.length; ++i) {
                    if (!this.queueNameCache[i].equals(queueName) && !this.translate(this.queueNameCache[i]).equals(queueName) && (!this.queueNameCache[i].endsWith(rpar) || !this.queueNameCache[i].startsWith(queueName)) && !this.translate(this.queueNameCache[i]).startsWith(queueName)) continue;
                    found = true;
                    queueConfig = this.findConfig(queueName, true);
                    if (queueConfig != null) {
                        queueType = queueConfig.getQueueType();
                        if (1 == queueType && queueName.endsWith(rpar)) {
                            throw new VWException("vw.api.SQueueInvalidServerSub", "The queue type does not support a server subscript.");
                        }
                        queueServer = queueConfig.getServerId();
                        isConnectorQueue = queueConfig.getIsConnectorQueue();
                    } else {
                        String tmpQueueName = queueName + "(0)";
                        queueConfig = this.findConfig(tmpQueueName, true);
                        if (queueConfig == null) {
                            throw new VWException("vw.api.SQueueWithServerSubNotFound", "User Information may need to be updated. Queue not found: \"{0}\".", tmpQueueName);
                        }
                        queueServer = queueConfig.getServerId();
                        queueType = queueConfig.getQueueType();
                        isConnectorQueue = queueConfig.getIsConnectorQueue();
                    }
                    if (!queueName.endsWith(rpar)) continue block3;
                    serverId = this.getQueueServerNum(queueName);
                    if (queueServer != serverId && queueServer != -1) {
                        throw new VWException("vw.api.SQueueWrongServerSub", "Queue \"{0}\" was not found on server \"{1}\".", queueName, serverId);
                    }
                    serverId = -1;
                    continue block3;
                }
            }
            if (!found) {
                throw new VWException("vw.api.SQueueNameInvalid", "The queue name \"{0}\" is not valid for this session.", queueName);
            }
            VWQueue queueSession = new VWQueue(this.translateToAuthored(queueName), this, queueType, serverId, isConnectorQueue);
            queueSession.setConfigInfo(queueConfig);
            VWQueue vWQueue = queueSession;
            return vWQueue;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    protected void checkSession() throws VWException {
        if (this.cmdSession == null) {
            throw new VWException("vw.api.SNoLogon", "No logged-on session exists.");
        }
    }

    protected String getUserName() {
        return this.userName;
    }

    protected long getWsTimeStamp() throws VWException {
        VWConfigResult configmap = this.cmdSession.getConfigInfo(false);
        return configmap.getWsTimeStamp();
    }

    public boolean isLoggedOn() {
        return this.cmdSession != null;
    }

    public void logoff() throws VWException {
        String m_method = "logoff";
        try {
            this.checkSession();
            this.cmdSession.logoff();
        }
        catch (Exception ex) {
            Object var2_3 = null;
        }
        this.cmdSession = null;
        if (logger.isFinest()) {
            logger.finest(m_className, "logoff", "completed.");
        }
    }

    public String[] getQueueNames(boolean includeSystem) throws VWException {
        this.checkSession();
        return this.cmdSession.getQueueNames(includeSystem, false);
    }

    public String[] fetchQueueNames(int fetchFlag) throws VWException {
        this.checkSession();
        Object[] result = null;
        boolean ignoreSecurity = false;
        int serverId = 0;
        int qserverId = 0;
        if ((fetchFlag & 0x10) == 16) {
            ignoreSecurity = true;
        }
        String[] queueNames = this.cmdSession.getQueueNames(true, ignoreSecurity);
        Vector<String> temp = new Vector<String>();
        int type = 0;
        for (int i = 0; i < queueNames.length; ++i) {
            type = this.findQueueType(queueNames[i]);
            if (type == 3) {
                type = 4;
            }
            if ((type & 2) == 2 && (fetchFlag & 0x20) == 32) {
                qserverId = this.getQueueServerNum(queueNames[i]);
                if (qserverId != serverId) continue;
                temp.addElement(queueNames[i]);
                continue;
            }
            if ((type & fetchFlag) <= 0) continue;
            temp.addElement(queueNames[i]);
        }
        result = new String[temp.size()];
        temp.copyInto(result);
        return this.translateStrArray((String[])result);
    }

    public String[] getRosterNames() throws VWException {
        this.checkSession();
        return this.cmdSession.getRosterNames(false);
    }

    public String[] fetchRosterNames(boolean ignoreSecurity) throws VWException {
        this.checkSession();
        String[] tmp = this.cmdSession.getRosterNames(ignoreSecurity);
        return this.translateStrArray(tmp);
    }

    public String[] fetchLaunchableWorkClassNames() throws VWException {
        this.checkSession();
        String[] serverClassList = this.cmdSession.getWorkClassNames(false, null);
        Vector<String> filteredClassListVec = new Vector<String>();
        for (int i = 0; i < serverClassList.length; ++i) {
            if (serverClassList[i].equals("WorkObject") || serverClassList[i].equals("WorkObjectEx") || serverClassList[i].equals("CaseWorkObject")) continue;
            filteredClassListVec.add(serverClassList[i]);
        }
        Object[] resultClassArray = new String[filteredClassListVec.size()];
        filteredClassListVec.copyInto(resultClassArray);
        return this.translateStrArray((String[])resultClassArray);
    }

    public String[] fetchWorkClassNames(boolean ignoreSecurity) throws VWException {
        this.checkSession();
        String[] serverClassList = this.fetchWorkClassNames(true, null);
        Vector<String> filteredClassListVec = new Vector<String>();
        for (int i = 0; i < serverClassList.length; ++i) {
            if (serverClassList[i].equals("WorkObject") || serverClassList[i].equals("WorkObjectEx") || serverClassList[i].equals("CaseWorkObject")) continue;
            filteredClassListVec.add(serverClassList[i]);
        }
        Object[] resultClassArray = new String[filteredClassListVec.size()];
        filteredClassListVec.copyInto(resultClassArray);
        return this.translateStrArray((String[])resultClassArray);
    }

    public String[] fetchWorkClassNames(boolean ignoreSecurity, String inheritFromWorkClassName) throws VWException {
        this.checkSession();
        if (inheritFromWorkClassName != null && inheritFromWorkClassName.length() == 0) {
            inheritFromWorkClassName = null;
        }
        String[] serverClassList = this.cmdSession.getWorkClassNames(true, inheritFromWorkClassName);
        return serverClassList;
    }

    public String getCurrentVersion() {
        return "2.0";
    }

    public int convertUserNameToId(String aUserName) throws VWException {
        Long ret;
        this.checkSession();
        if (aUserName == null || aUserName.length() == 0) {
            throw new VWException("vw.api.SConvertUserNameNull", "convertUserNameToId, User name was null or empty");
        }
        int result = -1;
        if (USTR_NONE.equals(aUserName)) {
            return 0;
        }
        if (USTR_ANYONE.equals(aUserName)) {
            return 1;
        }
        if (USTR_SERVICE.equals(aUserName)) {
            return 5;
        }
        if (USTR_INTERNAL_USER.equals(aUserName)) {
            return 7;
        }
        if (this.secList == null) {
            this.secList = new VWSecurityList(this, 2000000, 3, this.userName, this.cmdSession.getSecurityId(), null, null, 0, 0, 0L, false);
        }
        if (this.secList != null && (ret = this.cmdSession.getSecurityType() <= 0 ? this.secList.findId(aUserName, true) : this.secList.findLDAPId(aUserName, this.cmdSession.isSecurityCaseSensitive())) != null) {
            result = ret.intValue();
        }
        if (result == -1) {
            throw new VWException("vw.api.SConvertUserNameToIdNotFound", "convertUserNameToId, User name {0} not found.", aUserName);
        }
        return result;
    }

    public String convertIdToUserName(int aUserId) throws VWException {
        this.checkSession();
        String result = null;
        if (aUserId < 0) {
            throw new VWException("vw.api.SConvertIdToUserNameIdNull", "convertIdToUserName: User Id is less than zero");
        }
        switch (aUserId) {
            case 0: {
                result = USTR_NONE;
                break;
            }
            case 1: {
                result = USTR_ANYONE;
                break;
            }
            case 5: {
                result = USTR_SERVICE;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                result = USTR_INTERNAL_USER;
                break;
            }
            default: {
                if (this.secList == null) {
                    this.secList = new VWSecurityList(this, 2000000, 3, this.userName, this.cmdSession.getSecurityId(), null, null, 0, 0, 0L, false);
                }
                if ((result = this.cmdSession.getSecurityType() <= 0 ? this.secList.findName(Long.valueOf(aUserId)) : this.secList.findLDAPName(Long.valueOf(aUserId))) != null) break;
                throw new VWException("vw.api.SConvertIdToUserNameIdNotFound", "convertIdToUserName, User Id {0} not found.", aUserId);
            }
        }
        return result;
    }

    public void updateAPIUserCache() throws VWException {
        this.checkSession();
        this.secList = null;
    }

    public int convertClassNameToId(String aClassName, boolean aQueueClassType) throws VWException {
        this.checkSession();
        int result = -1;
        VWConfigInfo[] configinfo = null;
        int retryLoop = 0;
        if (aClassName == null) {
            throw new VWException("vw.api.SConvertClassNameNull", "convertClassNameToId: Class name was null");
        }
        for (retryLoop = 0; retryLoop < 2; ++retryLoop) {
            VWConfigResult configmap = this.cmdSession.getConfigInfo(retryLoop != 0);
            if (configmap != null) {
                if (aQueueClassType) {
                    configinfo = configmap.getQueueConfigs();
                } else {
                    configinfo = configmap.getRosterConfigs();
                    result = this.findClassId(configinfo, this.translateToAuthored(aClassName));
                    if (result != -1) {
                        return result;
                    }
                    configinfo = this.cmdSession.getWorkClassIdConfig();
                }
            }
            if (configinfo != null) {
                result = this.findClassId(configinfo, this.translateToAuthored(aClassName));
            }
            if (result == -1) continue;
            return result;
        }
        throw new VWException("vw.api.SClassNameNotFound", "convertClassNameToId: Class Name {0} not found", aClassName);
    }

    protected int findClassId(VWConfigInfo[] strarr, String aClassName) {
        VWConfigInfo classInfo = null;
        int result = -1;
        String name = null;
        if (strarr != null && strarr.length > 0) {
            for (int i = 0; i < strarr.length; ++i) {
                classInfo = strarr[i];
                if (classInfo == null || !(name = classInfo.getName()).equals(aClassName) && !name.equals(aClassName + "(0)")) continue;
                result = classInfo.getClassId();
                break;
            }
        }
        return result;
    }

    public String convertIdToClassName(int aClassId, boolean aQueueClassType) throws VWException {
        this.checkSession();
        String result = null;
        VWConfigInfo[] configinfo = null;
        int retryLoop = 0;
        for (retryLoop = 0; retryLoop < 2; ++retryLoop) {
            VWConfigResult configmap = this.cmdSession.getConfigInfo(retryLoop != 0);
            if (configmap != null) {
                if (aQueueClassType) {
                    configinfo = configmap.getQueueConfigs();
                } else {
                    configinfo = configmap.getRosterConfigs();
                    result = this.findClassName(configinfo, aClassId);
                    if (result != null) {
                        return this.translate(result);
                    }
                    configinfo = this.cmdSession.getWorkClassIdConfig();
                }
            }
            if (configinfo != null) {
                result = this.findClassName(configinfo, aClassId);
            }
            if (result == null) continue;
            return this.translate(result);
        }
        throw new VWException("vw.api.SClassIdNotFound", "convertIdToClassName: Class Id {0} not found", aClassId);
    }

    protected String findClassName(VWConfigInfo[] strarr, int aClassId) {
        String result = null;
        VWConfigInfo classInfo = null;
        int id = -1;
        if (strarr != null && strarr.length > 0) {
            for (int i = 0; i < strarr.length; ++i) {
                classInfo = strarr[i];
                if (classInfo == null || (id = classInfo.getClassId()) != aClassId) continue;
                result = classInfo.getName();
                if (!classInfo.getQueueFlag() || 1 == classInfo.getQueueType()) break;
                String tmp = result;
                int inx = tmp.indexOf(lpar);
                result = tmp.substring(0, inx);
                break;
            }
        }
        return result;
    }

    protected int findQueueType(String aName) throws VWException {
        this.checkSession();
        String name = null;
        String par = rpar;
        VWConfigInfo[] configInfo = null;
        for (int loopCnt = 0; loopCnt < 2; ++loopCnt) {
            VWConfigResult configmap = this.cmdSession.getConfigInfo(loopCnt != 0);
            if (configmap != null) {
                configInfo = configmap.getQueueConfigs();
            }
            int nConfigs = configInfo == null ? 0 : configInfo.length;
            for (int i = 0; i < nConfigs; ++i) {
                if (configInfo[i] == null || !aName.equals(name = configInfo[i].getName()) && (!aName.endsWith(rpar) || !aName.startsWith(name))) continue;
                return configInfo[i].getQueueType();
            }
        }
        return -1;
    }

    protected VWConfigInfo findConfig(String aName, boolean isQueue) throws VWException {
        this.checkSession();
        String par = rpar;
        for (int retryCount = 0; retryCount < 2; ++retryCount) {
            String name;
            int i;
            int nConfigs;
            VWConfigResult configmap = this.cmdSession.getConfigInfo(retryCount != 0);
            VWConfigInfo[] configInfo = null;
            if (configmap != null) {
                configInfo = isQueue ? configmap.getQueueConfigs() : configmap.getRosterConfigs();
            }
            int n = nConfigs = configInfo == null ? 0 : configInfo.length;
            if (nConfigs == 0) continue;
            for (i = 0; i < nConfigs; ++i) {
                if (configInfo[i] == null || !aName.equals(name = configInfo[i].getName()) && (!aName.endsWith(rpar) || !aName.startsWith(name))) continue;
                return configInfo[i];
            }
            if (this.getClientLocale() == null) continue;
            for (i = 0; i < nConfigs; ++i) {
                if (configInfo[i] == null || !aName.equals(name = this.translate(configInfo[i].getName())) && (!aName.endsWith(rpar) || !aName.startsWith(name))) continue;
                return configInfo[i];
            }
        }
        return null;
    }

    public boolean recoverUser(String userName, String[] queueNames) throws VWException {
        this.checkSession();
        boolean result = true;
        VWConfigResult configmap = this.cmdSession.getConfigInfo(true);
        VWConfigInfo[] configInfo = configmap.getQueueConfigs();
        String name = null;
        Vector<String> vobj = new Vector<String>();
        if (configInfo != null && configInfo.length > 0) {
            String[] queues;
            if (queueNames == null || queueNames.length < 0) {
                for (int i = 0; i < configInfo.length; ++i) {
                    if (configInfo[i] == null) continue;
                    name = configInfo[i].getName();
                    vobj.addElement(name);
                }
            } else {
                boolean found = false;
                for (int ii = 0; ii < queueNames.length; ++ii) {
                    for (int i = 0; i < configInfo.length; ++i) {
                        found = false;
                        if (configInfo[i] == null || !(name = configInfo[i].getName()).equals(queueNames[ii])) continue;
                        found = true;
                        vobj.addElement(name);
                        break;
                    }
                    if (found) continue;
                    throw new VWException("vw.api.SRecoverUserQueueNotFound", "The queue name is invalid or was not found for the recover user {0}", queueNames[ii]);
                }
            }
            if ((queues = vobj.toArray(new String[0])) != null && queues.length > 0) {
                String dest = VWCommandSession.serverDestination(this.serviceName, 0, this.isolatedRegion);
                IPECommands serverCmdSession = this.cmdSession.getIPECommandsForDest(dest);
                result = serverCmdSession.recoverUser(userName, queues);
            }
        }
        return result;
    }

    public VWLog fetchEventLog(String eventLogName) throws VWException {
        String transName;
        VWLog logSession = null;
        if (eventLogName == null) {
            throw new VWException("vw.api.SEventLogNameNull", "The log name is null.");
        }
        this.checkSession();
        String[] logNames = this.fetchEventLogNames();
        boolean found = false;
        for (int i = 0; i < logNames.length; ++i) {
            if (!eventLogName.equals(logNames[i])) continue;
            found = true;
            break;
        }
        if (!found && this.getClientLocale() != null && !(transName = this.translate(eventLogName)).equals(eventLogName)) {
            for (int i = 0; i < logNames.length; ++i) {
                if (!transName.equals(logNames[i])) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new VWException("vw.api.SLogNameInvalid", "The log name {0} is not valid for this session.", eventLogName);
        }
        logSession = new VWLog(this.translateToAuthored(eventLogName), this);
        return logSession;
    }

    public String[] fetchEventLogNames() throws VWException {
        this.checkSession();
        String[] result = this.cmdSession.getLogNames();
        return this.translateStrArray(result);
    }

    public void setAuditState(String fileName, Integer[] options) throws Exception {
        this.auditFile = fileName;
        this.auditOn = options[0] == 1;
    }

    public String toString() {
        return this.m_originalCPName + " " + this.isolatedRegion;
    }

    public String getRouterURL() {
        return this.m_originalCPName;
    }

    public String getConnectionPointName() throws VWException {
        this.checkSession();
        return this.cmdSession.getConnectionPointName();
    }

    public VWSystemAdministration fetchSystemAdministration() throws VWException {
        this.checkSession();
        return new VWSystemAdministration(this);
    }

    public VWSystemConfiguration fetchSystemConfiguration() throws VWException {
        this.checkSession();
        return new VWSystemConfiguration(this, true);
    }

    public Session createMailSession() throws VWException {
        this.checkSession();
        String[] propKeys = new String[]{"SMTPHost", "SMTPPort", "EMailLogonId", "EMailLogonPassword"};
        Hashtable propValues = this.cmdSession.fetchServerConfiguration(propKeys);
        Properties props = new Properties();
        String sSMTPHost = (String)propValues.get("SMTPHost");
        String sSMTPPort = (String)propValues.get("SMTPPort");
        String sLogonId = (String)propValues.get("EMailLogonId");
        String sPassword = (String)propValues.get("EMailLogonPassword");
        if (sPassword != null && sPassword.length() > 0) {
            try {
                VWMailAuthenticationConvertTwo converter = new VWMailAuthenticationConvertTwo(0);
                VWAuthItem item = converter.getDString(sPassword);
                if (item != null) {
                    sPassword = item.getPassword();
                }
            }
            catch (Exception ex) {
                throw new VWException(ex);
            }
        }
        props.put("mail.smtp.host", sSMTPHost);
        if (sSMTPPort != null && sSMTPPort.length() > 0) {
            props.put("mail.smtp.port", sSMTPPort);
        }
        boolean bAuthenticationRequired = false;
        if (sLogonId != null && sLogonId.length() > 0 && sPassword != null && sPassword.length() > 0) {
            bAuthenticationRequired = true;
        }
        if (logger.isLoggable(Level.FINEST)) {
            props.put("mail.debug", "true");
        } else {
            props.put("mail.debug", "false");
        }
        Session theMailSession = null;
        try {
            if (bAuthenticationRequired) {
                props.put("mail.smtp.auth", "true");
                VWMailAuthenticator aMailAuthenticator = new VWMailAuthenticator(sLogonId, sPassword);
                theMailSession = Session.getInstance((Properties)props, (Authenticator)aMailAuthenticator);
            } else {
                props.put("mail.smtp.auth", "false");
                theMailSession = Session.getInstance((Properties)props, null);
            }
        }
        catch (Exception ex) {
            throw new VWException(ex);
        }
        return theMailSession;
    }

    public VWUserInfo fetchUserInfo(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.SfetchUserInfoNameNullOrEmpty", "fetchUserInfo parameter name is null or empty.");
        }
        String[] theNameList = new String[]{theName};
        VWUserInfo[] resultList = this.fetchUserInfoList(theNameList);
        if (resultList != null && resultList.length > 0) {
            return resultList[0];
        }
        return null;
    }

    public String fetchFileFromServer(String theFileName, int theFileType) throws VWException {
        String m_method = "fetchFileFromServer:" + theFileName + DELIM + Integer.toString(theFileType);
        if (theFileName == null || theFileName.length() == 0) {
            throw new VWException("vw.api.SfetchFileFromServerNameNullOrEmpty", "fetchFileFromServer, parameter theFileName is null or empty.");
        }
        if (theFileName.indexOf("..") != -1) {
            throw new VWException("vw.api.SfetchFileFromServerNameContainsDotDot", "The file name contains the character sequence used to navigate to a parent directory, \"..\". File names of files to be fetched from the server must not contain \"..\"");
        }
        if (theFileName.indexOf(58) != -1) {
            throw new VWException("vw.api.SfetchFileFromServerNameContainsColon", "The file name contains a colon, '':'', character.  File names of files to be fetched from the server must not contain a colon, '':''");
        }
        if (theFileType != 2 && theFileType != 1) {
            throw new VWException("vw.api.SfetchFileFromServerBadFileType", "The file type {0} is an invalid file type specifier.", String.valueOf(theFileType));
        }
        this.checkSession();
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "calling getFileFromServer");
        }
        String fileContents = this.cmdSession.getFileFromServer(theFileName, theFileType);
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "done");
        }
        return fileContents;
    }

    public VWUserInfo[] fetchUserInfoList(String[] theNameList) throws VWException {
        if (theNameList == null || theNameList.length < 1) {
            throw new VWException("vw.api.SfetchUserInfoNameNull", "fetchUserInfos parameter name list is null.");
        }
        this.checkSession();
        VWEnvironmentData[] theEnviros = this.cmdSession.fetchUserInfo(theNameList);
        int sz = theEnviros.length;
        VWUserInfo[] result = new VWUserInfo[sz];
        for (int i = 0; i < sz; ++i) {
            result[i] = new VWUserInfo(this, theEnviros[i]);
            if (result[i].getName() != null) continue;
            result[i].setVWParticipant(theNameList[i]);
        }
        return result;
    }

    public VWSecurityList fetchUserGroups(int maxBufferSize) throws VWException {
        VWSecurityList result = null;
        this.checkSession();
        switch (this.cmdSession.getSecurityType()) {
            case 0: {
                result = new VWSecurityList(this, maxBufferSize, 2, null, null, 0, 0, 0L);
                break;
            }
            case 1: {
                result = new VWSecurityList(this, maxBufferSize, 2, null, null, 0, 0, 1L);
            }
        }
        return result;
    }

    public VWParticipantList fetchUserGroupsPx(int maxBufferSize) throws VWException {
        VWParticipantList result = null;
        this.checkSession();
        switch (this.cmdSession.getSecurityType()) {
            case 0: {
                result = new VWParticipantList(this, maxBufferSize, 2, null, null, 0, 0, 0L);
                break;
            }
            case 1: {
                result = new VWParticipantList(this, maxBufferSize, 2, null, null, 0, 0, 1L);
            }
        }
        return result;
    }

    public VWSecurityList fetchUsers(int maxBufferSize, boolean bIncludeGroups) throws VWException {
        VWSecurityList result = null;
        this.checkSession();
        int listType = 1;
        if (bIncludeGroups) {
            listType = 3;
        }
        switch (this.cmdSession.getSecurityType()) {
            case 0: {
                result = new VWSecurityList(this, maxBufferSize, listType, null, null, 0, 0, 0L);
                break;
            }
            case 1: {
                result = new VWSecurityList(this, maxBufferSize, listType, null, null, 0, 0, 1L);
            }
        }
        return result;
    }

    public VWParticipantList fetchUsersPx(int maxBufferSize, boolean bIncludeGroups) throws VWException {
        VWParticipantList result = null;
        this.checkSession();
        int listType = 1;
        if (bIncludeGroups) {
            listType = 3;
        }
        switch (this.cmdSession.getSecurityType()) {
            case 0: {
                result = new VWParticipantList(this, maxBufferSize, listType, null, null, 0, 0, 0L);
                break;
            }
            case 1: {
                result = new VWParticipantList(this, maxBufferSize, listType, null, null, 0, 0, 1L);
            }
        }
        return result;
    }

    public VWSecurityList findUsers(String searchPattern, int searchType, int sortType, int maxBufferSize) throws VWException {
        VWSecurityList result = null;
        this.checkSession();
        if (this.cmdSession.getSecurityType() <= 0) {
            throw new VWException("vw.api.SfindUsers", "findUsers is only supported for LDAP Security Databases.");
        }
        result = new VWSecurityList(this, maxBufferSize, 1, searchPattern, null, searchType, sortType, 1L);
        return result;
    }

    public VWSecurityList findGroups(String searchPattern, int searchType, int sortType, int maxBufferSize) throws VWException {
        VWSecurityList result = null;
        this.checkSession();
        if (this.cmdSession.getSecurityType() <= 0) {
            throw new VWException("vw.api.SfindGroups", "findGroups is only supported for LDAP Security Databases.");
        }
        result = new VWSecurityList(this, maxBufferSize, 2, searchPattern, null, searchType, sortType, 1L);
        return result;
    }

    public VWParticipantList findUsersByDomain(String secDomainName, String searchPattern, int searchType, int sortType, int maxBufferSize) throws VWException {
        VWParticipantList result = null;
        if (this.cmdSession.getSecurityType() <= 0) {
            throw new VWException("vw.api.SfindUsers", "findUsersbyDomain is only supported for LDAP Security Databases.");
        }
        this.checkSession();
        result = new VWParticipantList(this, maxBufferSize, 1, searchPattern, secDomainName, searchType, sortType, 1L);
        return result;
    }

    public VWParticipantList findGroupsByDomain(String secDomainName, String searchPattern, int searchType, int sortType, int maxBufferSize) throws VWException {
        VWParticipantList result = null;
        this.checkSession();
        if (this.cmdSession.getSecurityType() <= 0) {
            throw new VWException("vw.api.SfindUsers", "findGroupsbyDomain is only supported for LDAP Security Databases.");
        }
        result = new VWParticipantList(this, maxBufferSize, 2, searchPattern, secDomainName, searchType, sortType, 1L);
        return result;
    }

    public int getSecurityDatabaseType() throws VWException {
        int result = 0;
        this.checkSession();
        result = this.cmdSession.getSecurityType() <= 0 ? 0 : 1;
        return result;
    }

    protected String getNCHServerName() throws VWException {
        this.checkSession();
        VWConfigResult configmap = this.cmdSession.getConfigInfo(false);
        if (configmap != null) {
            return configmap.getNCHServerName();
        }
        return null;
    }

    public String getPEServerName() throws VWException {
        if (this.NCHServerName == null) {
            this.getNCHServerValues();
        }
        return this.NCHServerName;
    }

    public int getDatabaseType() throws VWException {
        int result = 0;
        this.checkSession();
        VWConfigResult configmap = this.cmdSession.getConfigInfo(false);
        if (configmap != null) {
            result = configmap.getDBType();
        }
        if (result == 4 || result == 6) {
            result = 2;
        }
        if (result == 5) {
            result = 3;
        }
        return result;
    }

    protected int getIsolatedRegionWebApp() throws VWException {
        this.checkSession();
        VWConfigResult configmap = this.cmdSession.getConfigInfo(false);
        if (configmap != null) {
            return configmap.getIsolatedRegionDefaultWebApp();
        }
        return 0;
    }

    public VWUserInfo fetchCurrentUserInfo() throws VWException {
        return this.fetchUserInfo(this.userName);
    }

    public VWTransferResult transfer(VWWorkflowDefinition theWorkflow, String theWFDocKey, boolean theLinked, boolean theMakeNewWorkSpace) throws VWException {
        if (theWorkflow == null) {
            throw new VWException("vw.api.SNullWorkflowDefinition", "The workflow definition is null.");
        }
        VWTransferResult theResult = null;
        this.checkSession();
        this.convertToCanonicalForm(theWorkflow);
        theResult = this.cmdSession.transfer(null, theWorkflow, theWFDocKey, theLinked, theMakeNewWorkSpace, this.webAppId);
        return theResult;
    }

    public VWTransferResult transferWFCollection(VWWorkflowCollectionDefinition theWorkflowColl, String theWFDocKey, boolean theLinked, boolean theMakeNewWorkSpace) throws VWException {
        if (theWorkflowColl == null) {
            throw new VWException("vw.api.SNullWorkflowCollectionDefinition", "The workflow collection definition is null.");
        }
        VWTransferResult theResult = null;
        this.checkSession();
        theResult = this.cmdSession.transferWorkflowCollection(theWorkflowColl.asXMLString(), theWFDocKey, theLinked, theMakeNewWorkSpace);
        return theResult;
    }

    public boolean isRegionInitialized() throws Exception {
        try {
            VWConfigResult configmap = this.cmdSession.getConfigInfo(false);
            if (configmap != null) {
                return true;
            }
        }
        catch (VWNoOnlineClassesException vWNoOnlineClassesException) {
            // empty catch block
        }
        return false;
    }

    protected void convertToCanonicalForm(VWWorkflowDefinition theWorkflow) throws VWException {
        VWFieldDefinition[] fieldList = theWorkflow.getFields();
        if (fieldList != null) {
            for (int i = 0; i < fieldList.length; ++i) {
                Object value;
                if (fieldList[i].getFieldType() != 16 || !((value = fieldList[i].getValue()) instanceof Date)) continue;
                String stringValue = fieldList[i].getStringValue().trim();
                StringTokenizer dTk = new StringTokenizer(stringValue, "\"'`");
                String dateString = dTk.nextToken();
                String canonicalForm = "stringtotime(\"" + dateString + "\",\"" + "mm/dd/yyyy hh:tt:ss" + "\")";
                fieldList[i].setValue(canonicalForm, 16, false);
            }
        }
    }

    public VWStepElement createWorkflow(String workflowIdentifier) throws VWException {
        if (workflowIdentifier == null || workflowIdentifier.length() == 0) {
            throw new VWException("vw.api.SWorkflowIdentifierNull", "The workflowIdentifier is null or empty.");
        }
        this.checkSession();
        boolean servers = true;
        boolean returnWobNum = false;
        boolean isVersionString = VWSession.isVWVersionString(workflowIdentifier);
        VWField[] theFields = null;
        if (servers > true) {
            String workClassName = null;
            if (isVersionString) {
                workClassName = this.workClassFromVersionString(workflowIdentifier);
                if (workClassName == null) {
                    throw new VWException("vw.api.SWorkflowIdentifierBad1", "The workflowIdentifier <{0}> is bad.", workflowIdentifier);
                }
            } else {
                workClassName = workflowIdentifier = this.translateToAuthored(workflowIdentifier);
            }
            String rosterName = this.findRosterFromWorkClass(workClassName);
            String dest = VWCommandSession.rosterDestination(this.serviceName, this.cmdSession.getIsolatedRegion(), rosterName);
            IPECommands rCmdSession = this.cmdSession.getIPECommandsForDest(dest);
            theFields = isVersionString ? rCmdSession.getNewStepFromVWVersion(workflowIdentifier) : rCmdSession.getNewStepElement(workflowIdentifier, returnWobNum);
        } else {
            theFields = isVersionString ? this.cmdSession.getNewStepFromVWVersion(workflowIdentifier) : this.cmdSession.getNewStepElement(workflowIdentifier, returnWobNum);
        }
        VWStepElement result = null;
        if (theFields != null) {
            result = new VWStepElement(theFields, this, returnWobNum, null, null);
        }
        return result;
    }

    protected VWStepElement createWorkflow4REST(String workClassName) throws VWException {
        if (workClassName == null || workClassName.length() == 0) {
            throw new VWException("vw.api.SWorkflowIdentifierNull", "The workflowIdentifier is null or empty.");
        }
        this.checkSession();
        VWField[] theFields = this.cmdSession.getNewStepElement(this.translateToAuthored(workClassName), true);
        VWStepElement result = null;
        if (theFields != null) {
            result = new VWStepElement(theFields, this, true, null, null);
        }
        return result;
    }

    protected String findRosterFromWorkClass(String workClassName) throws VWException {
        if (workClassName == null) {
            throw new VWException("vw.api.SNullWorkflowIdentifier", "No work class name was specified. A null value was supplied for the work class name, so no associated roster could be found. Ensure that a valid work class name is being specified.");
        }
        int vid = 0;
        for (int retryCnt = 0; retryCnt < 2; ++retryCnt) {
            int i;
            VWConfigResult configmap = this.cmdSession.getConfigInfo(retryCnt != 0);
            VWConfigInfo[] ciarr = configmap.getWorkClassConfigs();
            VWConfigInfo classInfo = null;
            String name = null;
            if (ciarr == null || ciarr.length <= 0) continue;
            for (i = 0; i < ciarr.length; ++i) {
                classInfo = ciarr[i];
                if (classInfo == null || !(name = classInfo.getName()).equals(workClassName) && !name.startsWith(workClassName)) continue;
                vid = classInfo.getViewId();
                break;
            }
            if ((ciarr = configmap.getRosterConfigs()) == null) continue;
            for (i = 0; i < ciarr.length; ++i) {
                classInfo = ciarr[i];
                if (classInfo == null || vid != classInfo.getClassId()) continue;
                return classInfo.getName();
            }
        }
        throw new VWException("vw.api.SWorkflowIdentifierBad3", "Could not find roster associated with: <{0}> for viewid {1}", workClassName, String.valueOf(vid));
    }

    public boolean isMemberOfGroup(String groupName) throws VWException {
        if (groupName == null || groupName.length() == 0) {
            throw new VWException("vw.api.SInvalidGroupName", "The group name is null or empty.");
        }
        this.checkSession();
        long rpcArgBitMask = 0L;
        boolean isMemberOfGroup = this.cmdSession.isMemberOfGroup(groupName, null, rpcArgBitMask);
        return isMemberOfGroup;
    }

    public boolean[] fetchIsGroup(String[] names) throws VWException {
        if (names == null) {
            throw new VWException("vw.api.SFetchIsGroupNamesNull", "The array of names is null.");
        }
        boolean[] isGroup = null;
        this.checkSession();
        Boolean[] results = this.cmdSession.fetchIsGroup(names);
        if (results != null && results.length > 0) {
            isGroup = new boolean[results.length];
            for (int i = 0; i < results.length; ++i) {
                isGroup[i] = results[i];
            }
        }
        return isGroup;
    }

    public String getToken() throws VWException {
        String result = null;
        this.checkSession();
        result = this.cmdSession.getToken();
        return result;
    }

    public VWStepProcessorInfo[] fetchStepProcessors(int processorFlag) throws VWException {
        if (processorFlag < 1) {
            return null;
        }
        this.checkSession();
        VWStepProcessorInfo[] theProcessors = this.cmdSession.getStepProcessorList(processorFlag, this.webAppId);
        if (theProcessors != null) {
            for (int i = 0; i < theProcessors.length; ++i) {
                if (theProcessors[i] == null) continue;
                theProcessors[i].setDefaultWebAppId(this.getDefaultWebApplication());
                theProcessors[i].setIsolatedRegionWebAppId(this.getIsolatedRegionWebApp());
                theProcessors[i].setSession(this);
            }
        }
        return theProcessors;
    }

    public VWStepProcessorInfo fetchLaunchStepProcessor(String workflowIdentifier) throws VWException {
        if (workflowIdentifier == null || workflowIdentifier.length() == 0) {
            throw new VWException("vw.api.VWSessionWorkflowIdentifierCannotBeNull", "workflowIdentifier parameter cannot be null or empty.");
        }
        this.checkSession();
        VWStepProcessorInfo theProcessor = this.cmdSession.getLaunchStepProcessor(this.translateToAuthored(workflowIdentifier), this.webAppId);
        if (theProcessor != null) {
            theProcessor.setDefaultWebAppId(this.getDefaultWebApplication());
            theProcessor.setIsolatedRegionWebAppId(this.getIsolatedRegionWebApp());
            theProcessor.setSession(this);
        }
        return theProcessor;
    }

    public VWStepProcessorInfo fetchStepProcessorInfo(String processorIdentifier) throws VWException {
        if (processorIdentifier == null || processorIdentifier.length() == 0) {
            throw new VWException("vw.api.SProcessorIdentifierIdentIsNullOrEmpty", "Cannot fetchStepProcessorInfo using a null or empty processorIdentifier.");
        }
        VWStepProcessorInfo result = null;
        this.checkSession();
        int processorId = -1;
        try {
            processorId = new Integer(processorIdentifier);
        }
        catch (NumberFormatException nex) {
            // empty catch block
        }
        result = processorId != -1 ? this.cmdSession.getStepProcessorById(processorId, this.webAppId) : this.cmdSession.getStepProcessorByName(processorIdentifier, this.webAppId);
        if (result != null) {
            result.setDefaultWebAppId(this.getDefaultWebApplication());
            result.setIsolatedRegionWebAppId(this.getIsolatedRegionWebApp());
            result.setSession(this);
        }
        return result;
    }

    public boolean checkWorkflowIdentifier(String workflowIdentifier) throws VWException {
        boolean result = false;
        this.checkSession();
        if (workflowIdentifier != null && VWSession.isVWVersionString(workflowIdentifier)) {
            result = this.cmdSession.checkVWVersion(workflowIdentifier);
        }
        return result;
    }

    public int getIsolatedRegion() throws VWException {
        this.checkSession();
        this.isolatedRegion = this.cmdSession.getIsolatedRegion();
        return this.isolatedRegion;
    }

    public void setProductId(int theProductId) throws VWException {
        switch (theProductId) {
            case 1: {
                this.webAppId = 2;
                break;
            }
            case 2: {
                this.webAppId = 1;
                break;
            }
            case 4: {
                this.webAppId = 3;
                break;
            }
            case 8: {
                this.webAppId = 100;
                break;
            }
            default: {
                throw new VWException("vw.api.SInvalidProductId", "The product id {0} is not valid.", theProductId);
            }
        }
    }

    public void setDefaultWebApplication(int theWebApplicationId) throws VWException {
        switch (theWebApplicationId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 100: {
                this.webAppId = theWebApplicationId;
                break;
            }
            default: {
                if (theWebApplicationId > 100) {
                    this.webAppId = theWebApplicationId;
                    break;
                }
                throw new VWException("vw.api.SInvalidWebApplicationId", "The Web Application id {0} is reserved", theWebApplicationId);
            }
        }
    }

    public int getDefaultWebApplication() throws VWException {
        return this.webAppId;
    }

    public VWProcess fetchProcess(int workSpaceId, int workClassId, String workflowNumber) throws VWException {
        if (workflowNumber == null) {
            throw new VWException("vw.api.SWorkflowNumberIsNull", "Cannot fetchProcess using a null workflowNumber.");
        }
        this.checkSession();
        VWProcess process = this.cmdSession.getProcess(workSpaceId, workClassId, workflowNumber);
        process.setServiceSession(this);
        return process;
    }

    public VWProcess fetchProcess(String rosterName, String workflowNumber) throws VWException {
        if (rosterName == null) {
            throw new VWException("vw.api.SfetchProcessNullRoster", "RosterName is null.");
        }
        if (workflowNumber == null) {
            throw new VWException("vw.api.SfetchProcessWorkflowNumberIsNull", "Cannot fetchProcess using a null workflowNumber.");
        }
        this.checkSession();
        String indexName = null;
        int queryOptions = 96;
        Object[] minValues = new Object[]{workflowNumber};
        Object[] maxValues = new Object[]{workflowNumber};
        VWRoster theRoster = this.getRoster(rosterName);
        theRoster.setBufferSize(1);
        VWRosterDefinition rosterDef = theRoster.fetchRosterDefinition();
        if (rosterDef != null) {
            VWIndexDefinition[] indexDefs = rosterDef.getIndexes();
            if (indexDefs != null) {
                for (int i = 0; i < indexDefs.length; ++i) {
                    String[] theFieldNames = indexDefs[i].getFieldNames();
                    if (theFieldNames[0].compareTo("F_WorkFlowNumber") != 0) continue;
                    indexName = "F_WorkFlowNumber";
                    break;
                }
            }
            if (indexName == null) {
                boolean isExpField = false;
                VWExposedFieldDefinition[] expFields = rosterDef.getFields();
                if (expFields != null) {
                    for (int i = 0; i < expFields.length; ++i) {
                        String theFieldName = expFields[i].getName();
                        if (theFieldName.compareTo("F_WorkFlowNumber") != 0) continue;
                        isExpField = true;
                    }
                }
                if (!isExpField) {
                    throw new VWException("vw.api.SfetchProcessNoFWorkflowNumber", "F_WorkFlowNumber must be an exposed field to use this method on roster: {0}", rosterName);
                }
            }
        }
        VWRosterQuery rosterQuery = null;
        if (indexName != null) {
            rosterQuery = theRoster.createQuery(indexName, maxValues, minValues, queryOptions, null, null, 1);
        } else {
            if (workflowNumber.startsWith("0x")) {
                workflowNumber = workflowNumber.substring(2);
            }
            Object[] theValues = new Object[]{new VWWorkObjectNumber(workflowNumber)};
            rosterQuery = theRoster.createQuery("", null, null, 0, "F_WorkFlowNumber = :x", theValues, 1);
        }
        VWProcess theProcess = null;
        if (rosterQuery != null) {
            VWWorkObject wob = (VWWorkObject)rosterQuery.next();
            if (wob == null) {
                throw new VWException("vw.api.SfetchProcessWobNotFound", "WorkFlow Number not found using: {0} in roster: {1}", workflowNumber, rosterName);
            }
            theProcess = wob.fetchProcess();
            if (theProcess == null) {
                throw new VWException("vw.api.SfetchProcessNoProcess", "The WorkFlow Number could not find related process for: {0} in roster: {1}", workflowNumber, rosterName);
            }
        }
        return theProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWCreateLiveWOResult[] createLiveWorkObject(String[] fieldNames, Object[] fieldValues, String workflowIdentifier, int numberToCreate) throws VWException {
        String m_method = "createLiveWorkObject:" + workflowIdentifier;
        VWTimerLog timer = new VWTimerLog("VWSession." + m_method);
        try {
            if (workflowIdentifier == null || workflowIdentifier.length() == 0) {
                throw new VWException("vw.api.SWorkflowIdentifierNullInCreateLiveWorkObject", "The workflowIdentifier is null or empty.");
            }
            if (numberToCreate < 1) {
                throw new VWException("vw.api.InvalidNumberOfWorkObjectToCreate", "Number of Work object to create is negative or zero.");
            }
            this.checkSession();
            VWCreateLiveWOResult[] results = this.cmdSession.createLiveWorkObject(fieldNames, fieldValues, this.translateToAuthored(workflowIdentifier), numberToCreate);
            if (results != null) {
                for (int i = 0; i < results.length; ++i) {
                    results[i].setSession(this);
                }
            }
            VWCreateLiveWOResult[] vWCreateLiveWOResultArray = results;
            return vWCreateLiveWOResultArray;
        }
        finally {
            logger.exiting(m_className, m_method);
            timer.stop();
        }
    }

    public VWWorkflowSignature fetchWorkflowSignature(String workflowIdentifier) throws VWException {
        if (workflowIdentifier == null || workflowIdentifier.length() == 0) {
            throw new VWException("vw.api.SWorkflowIdentIsNull", "Cannot fetchWorkflowSignature using a null or empty workflowIdentifier.");
        }
        this.checkSession();
        VWWorkflowSignature wflSignature = this.cmdSession.getWorkflowSignature(this.translateToAuthored(workflowIdentifier));
        wflSignature.setServiceSession(this);
        return wflSignature;
    }

    public VWWorkflowSignature[] fetchMultipleWorkflowSignatures(int flags) throws VWException {
        if (flags != 0 && flags != 1 && flags != 2) {
            throw new VWException("vw.api.fetchMultipleWorkflowSignaturesInvalidFlag", "Invalid flag {0} used in fetching multiple workflow signatures.", String.valueOf(flags));
        }
        this.checkSession();
        VWWorkflowSignature[] wflSignatures = this.cmdSession.getMultipleWorkflowSignatures(flags);
        if (wflSignatures != null) {
            for (int i = 0; i < wflSignatures.length; ++i) {
                wflSignatures[i].setServiceSession(this);
            }
        }
        return wflSignatures;
    }

    public VWWorkflowDefinition fetchWorkflowDefinition(int workSpaceId, String workflowIdentifier) throws VWException {
        return this.fetchWorkflowDefinition(workSpaceId, workflowIdentifier, false);
    }

    public VWWorkflowDefinition fetchWorkflowDefinition(int workSpaceId, String workflowIdentifier, boolean convert) throws VWException {
        if (workflowIdentifier == null || workflowIdentifier.length() == 0) {
            throw new VWException("vw.api.SWorkflowIdentifierNullInFetchWFDef", "The workflowIdentifier is null or empty in fetchWorkflowDefinition.");
        }
        if (workSpaceId < -1) {
            throw new VWException("vw.api.SInvalidWorkspaceId", "The workSpaceId is invalid: {0}", workSpaceId);
        }
        this.checkSession();
        BufferedReader bRdr = null;
        String xmlString = this.cmdSession.getWorkClassXML(workSpaceId, this.translateToAuthored(workflowIdentifier), true, convert);
        bRdr = new BufferedReader(new StringReader(xmlString));
        VWWorkflowDefinition retVal = VWWorkflowDefinition.read(bRdr);
        if (retVal != null) {
            retVal.setSession(this);
        }
        return retVal;
    }

    public String getServerName() throws VWException {
        this.checkSession();
        return this.cmdSession.getServerName();
    }

    public VWSecurityDomain getDefaultSecurityDomain() throws VWException {
        this.checkSession();
        VWSecurityDomain theDefaultDomain = new VWSecurityDomain(this.cmdSession.getDefaultDomain(), this.cmdSession.isSecurityCaseSensitive());
        return theDefaultDomain;
    }

    public VWAttributeInfo fetchAttributes(int nFlag) throws VWException {
        this.checkSession();
        if (nFlag != 1 && nFlag != 2) {
            throw new VWException("vw.api.SInvalidAttributeSpecificationFlag", "The attribute specifier flag {0} is not a valid value.", String.valueOf(nFlag));
        }
        VWAttributeInfo theAttributes = this.cmdSession.getAttributes(nFlag);
        return theAttributes;
    }

    public boolean checkSystemWideFlagSetting(int flagOptions) throws VWException {
        VWConfigResult configmap = this.cmdSession.getConfigInfo(false);
        if (configmap == null) {
            return false;
        }
        int sysWideFlag = configmap.getSystemWideFlag();
        return (sysWideFlag & flagOptions) > 0;
    }

    public VWRosterElement[] fetchAttachmentIsReferencedBy(VWAttachment anAttachment) throws VWException {
        return this.fetchAttachmentIsReferencedBy(anAttachment, 0, null);
    }

    public VWRosterElement[] fetchAttachmentIsReferencedBy(VWAttachment anAttachment, int theLimit) throws VWException {
        return this.fetchAttachmentIsReferencedBy(anAttachment, theLimit, null);
    }

    protected VWRosterElement[] fetchAttachmentIsReferencedBy(VWAttachment anAttachment, int theLimit, VWRosterElement fromHere) throws VWException {
        VWRosterElement[] response = null;
        if (!this.isAttachmentTrackingEnabled()) {
            throw new VWException("vw.api.SAttachmentTrackingDisabled", "The ''attachment tracking'' functionality is disabled.");
        }
        if (theLimit < 0) {
            throw new VWException("vw.api.SBadReferencedLimit", "The ''limit'' parameter to the fetchAttachmentIsReferencedBy method must be non-negative.");
        }
        if (anAttachment != null) {
            String wobNum = "";
            int workClassId = 0;
            if (fromHere != null) {
                wobNum = fromHere.getWorkObjectNumber();
                workClassId = fromHere.getWorkClassId();
            }
            VWQueryResults fromServer = this.cmdSession.fetchAttachmentIsReferencedBy(anAttachment, theLimit, workClassId, wobNum);
            String bogusQueryRosterName = this.fetchRosterNames(true)[0];
            VWRoster bogusRoster = this.getRoster(bogusQueryRosterName);
            VWRosterQuery bogusQuery = bogusRoster.createQuery("F_WobNum", null, null, 0, "", null, 4);
            int len = 0;
            if (fromServer != null && fromServer.fieldValues != null) {
                len = fromServer.fieldValues.length;
            }
            response = new VWRosterElement[len];
            for (int i = 0; i < len; ++i) {
                if (fromServer.fieldValues[i] == null) continue;
                for (int j = 0; j < fromServer.fieldValues[i].length; ++j) {
                    String thisRosterName;
                    if (!fromServer.fieldValues[i][j].getName().equals("*F_RosterName") || (thisRosterName = (String)fromServer.fieldValues[i][j].getValue()).equals(bogusQueryRosterName)) continue;
                    bogusQueryRosterName = thisRosterName;
                    bogusRoster = this.getRoster(thisRosterName);
                    bogusQuery = bogusRoster.createQuery("F_WobNum", null, null, 0, "", null, 4);
                }
                response[i] = new VWRosterElement(fromServer.fieldValues[i], fromServer.workObjectIds[i], bogusQuery);
            }
        }
        return response;
    }

    public VWAttachmentTrackingQuery createAttachmentTrackingQuery(VWAttachment anAttachment) throws VWException {
        if (!this.isAttachmentTrackingEnabled()) {
            throw new VWException("vw.api.SAttachmentTrackingDisabled", "The 'attachment tracking' functionality is disabled.");
        }
        return new VWAttachmentTrackingQuery(this, anAttachment);
    }

    public Boolean[] fetchAttachmentIsReferenced(VWAttachment[] theAttachments) throws VWException {
        if (!this.isAttachmentTrackingEnabled()) {
            throw new VWException("vw.api.SAttachmentTrackingDisabled", "The 'attachment tracking' functionality is disabled.");
        }
        Boolean[] response = null;
        if (theAttachments != null) {
            response = this.cmdSession.fetchAttachmentIsReferenced(theAttachments);
        }
        return response;
    }

    public VWUserInfo[] fetchUserRecords(int maxBufferSize, boolean throwException) throws VWException {
        Map sortedUserRecords;
        VWUserInfo[] results = null;
        Object[] sortedEnvData = null;
        this.checkSession();
        if (null == this.envDataList) {
            this.envDataList = new VWEnvironmentDataList(this, maxBufferSize, throwException);
        }
        if (null != this.envDataList && null != (sortedUserRecords = this.envDataList.getAllUserInfoRecords())) {
            sortedEnvData = sortedUserRecords.values().toArray();
        }
        results = new VWUserInfo[sortedEnvData.length];
        for (int i = 0; i < sortedEnvData.length; ++i) {
            results[i] = new VWUserInfo(this, (VWEnvironmentData)sortedEnvData[i]);
        }
        return results;
    }

    protected int getQueueServerNum(String queueName) throws VWException {
        int serverId = -1;
        if (queueName.endsWith(rpar)) {
            int linx = queueName.lastIndexOf(lpar);
            int rinx = queueName.lastIndexOf(rpar);
            String serverNum = queueName.substring(linx + 1, rinx);
            try {
                Integer serverx = Integer.valueOf(serverNum);
                serverId = serverx;
            }
            catch (NumberFormatException ne) {
                throw new VWException("vw.api.SQueueBadServerSub", "Number format Exception, Queue name server subscript not specified correctly (<num>) {0}", queueName);
            }
        }
        return serverId;
    }

    protected int getQueueType(int queueId) throws VWException {
        VWConfigInfo[] strarr = null;
        VWConfigResult configmap = this.cmdSession.getConfigInfo(false);
        strarr = configmap.getQueueConfigs();
        int result = 0;
        VWConfigInfo classInfo = null;
        int id = -1;
        if (strarr != null && strarr.length > 0) {
            for (int i = 0; i < strarr.length; ++i) {
                classInfo = strarr[i];
                if (classInfo == null || (id = classInfo.getClassId()) != queueId) continue;
                result = classInfo.getQueueType();
                break;
            }
        }
        return result;
    }

    protected static boolean isVWVersionString(String versionString) {
        int bell = 7;
        String tildas = "~~";
        return versionString != null && (versionString.indexOf(7) == 0 || versionString.startsWith("~~"));
    }

    protected String workClassFromVersionString(String versionString) throws VWException {
        String theName;
        block7: {
            theName = null;
            String token = null;
            try {
                StringTokenizer strTk = new StringTokenizer(versionString, "\t", false);
                int i = 0;
                while (strTk.hasMoreTokens()) {
                    token = strTk.nextToken();
                    if (i == 2) {
                        Integer regionid = new Integer(token);
                        if (this.isolatedRegion != regionid) {
                            throw new VWException("vw.api.SVWVersionCheck1", "VWVersion is for region: {0} not connected to correct vwrouter for VWVersion: \"{1}\" ", regionid, versionString);
                        }
                    } else if (i == 4) {
                        Integer rosterid = new Integer(token);
                        theName = this.convertIdToClassName(rosterid, false);
                        return theName;
                    }
                    ++i;
                }
            }
            catch (Exception Ex) {
                if (Ex == null) break block7;
                throw new VWException("vw.api.SVWVersionCheckExcption", "VWVersion exception: {0} not connected to correct vwrouter for VWVersion: \"{1}\" ", Ex.getMessage(), versionString);
            }
        }
        return theName;
    }

    protected String stripOrgAndDomain(String name) throws VWException {
        StringTokenizer stmp = null;
        boolean bLocalServer = false;
        if (this.NCHServerName == null) {
            this.getNCHServerValues();
        }
        if ((stmp = new StringTokenizer(name, DELIM, false)).hasMoreTokens()) {
            String tmpOrganization;
            String tmpDomain;
            String tmpName = stmp.nextToken();
            if (stmp.hasMoreTokens() && ((tmpDomain = stmp.nextToken()).equals(this.NCHServerDomain) || this.NCHServerDomain == null) && stmp.hasMoreTokens() && ((tmpOrganization = stmp.nextToken()).equals(this.NCHServerOrganization) || this.NCHServerOrganization == null)) {
                bLocalServer = true;
            }
            if (bLocalServer) {
                return tmpName;
            }
        }
        return name;
    }

    protected void getNCHServerValues() throws VWException {
        try {
            StringTokenizer stmp;
            if (this.NCHServerName == null) {
                this.NCHServerName = this.getNCHServerName();
            }
            if (this.NCHServerName != null && (stmp = new StringTokenizer(this.NCHServerName, DELIM, false)).hasMoreTokens()) {
                stmp.nextToken();
                if (stmp.hasMoreTokens()) {
                    this.NCHServerDomain = stmp.nextToken();
                    if (stmp.hasMoreTokens()) {
                        this.NCHServerOrganization = stmp.nextToken();
                    }
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof VWException) {
                throw (VWException)ex;
            }
            this.NCHServerName = null;
            this.NCHServerDomain = "FileNetDomain";
            this.NCHServerOrganization = "FileNet";
            return;
        }
    }

    public VWMilestoneElement[] fetchMilestonesFromRoster(String rosterName, String queryValue, int queryFlag, int milestoneLevel) throws VWException {
        this.checkSession();
        if (rosterName == null) {
            throw new VWException("vw.api.SfetchMilestonesForRosterElementNullRoster", "RosterName is null.");
        }
        if (queryValue == null) {
            throw new VWException("vw.api.SfetchMilestonesForRosterElementNullQueryValue", "QueryValue is null.");
        }
        VWRoster theRoster = this.getRoster(rosterName);
        theRoster.setBufferSize(1);
        String indexName = null;
        int queryOptions = 96;
        Object[] minValues = new Object[]{queryValue};
        Object[] maxValues = new Object[]{queryValue};
        if (queryFlag == 1) {
            VWRosterDefinition rosterDef = theRoster.fetchRosterDefinition();
            if (rosterDef != null) {
                VWIndexDefinition[] indexDefs = rosterDef.getIndexes();
                int count = 0;
                if (indexDefs != null) {
                    count = indexDefs.length;
                }
                for (int i = 0; i < count && indexName == null; ++i) {
                    String[] theFieldNames = indexDefs[i].getFieldNames();
                    if (theFieldNames[0].compareTo("F_WorkFlowNumber") != 0) continue;
                    indexName = "F_WorkFlowNumber";
                }
                if (indexName == null) {
                    VWExposedFieldDefinition[] expFields = rosterDef.getFields();
                    int fCount = 0;
                    boolean isExpField = false;
                    if (expFields != null) {
                        fCount = expFields.length;
                    }
                    for (int i = 0; i < fCount && !isExpField; ++i) {
                        String theFieldName = expFields[i].getName();
                        if (theFieldName.compareTo("F_WorkFlowNumber") != 0) continue;
                        isExpField = true;
                    }
                    if (!isExpField) {
                        throw new VWException("vw.api.SfetchMilestonesForRosterElementNoFWorkFlowNumber", "F_WorkFlowNumber must be an exposed field to use this method on roster: {0}", rosterName);
                    }
                }
            }
        } else {
            indexName = "F_WobNum";
        }
        VWRosterQuery rosterQuery = null;
        if (indexName != null) {
            rosterQuery = theRoster.createQuery(indexName, maxValues, minValues, queryOptions, null, null, 1);
        } else {
            if (queryValue.startsWith("0x")) {
                String tmpValue;
                queryValue = tmpValue = queryValue.substring(2);
            }
            Object[] theValues = new Object[]{new VWWorkObjectNumber(queryValue)};
            rosterQuery = theRoster.createQuery("", null, null, 0, "F_WorkFlowNumber = :x", theValues, 1);
        }
        if (rosterQuery != null) {
            VWWorkObject wob = (VWWorkObject)rosterQuery.next();
            if (wob != null) {
                VWProcess theProcess = wob.fetchProcess();
                if (theProcess != null) {
                    return theProcess.fetchFilteredWorkflowMilestones(milestoneLevel, false, false);
                }
                if (queryFlag == 1) {
                    throw new VWException("vw.api.SfetchMilestonesForRosterElementNoProcessMQWN", "The WorkFlow Number could not find related process for: {0} in roster: {1}", queryValue, rosterName);
                }
                throw new VWException("vw.api.SfetchMilestonesForRosterElementNoProcess", "The WorkObject could not find related process for: {0} in roster: {1}", queryValue, rosterName);
            }
            if (queryFlag == 1) {
                throw new VWException("vw.api.SfetchMilestonesForRosterElementWobNotFoundMQWN", "WorkFlow Number not found using: {0} in roster: {1}", queryValue, rosterName);
            }
            throw new VWException("vw.api.SfetchMilestonesForRosterElementWobNotFoundWobNotFound", "WorkObject not found using: {0} in roster: {1}", queryValue, rosterName);
        }
        return null;
    }

    public VWParticipant convertIdToUserNamePx(long userId) throws VWException {
        long[] listUserIds = new long[]{userId};
        VWParticipant[] results = this.convertIdsToUserNamesPx(listUserIds);
        if (results != null && results.length > 0) {
            return results[0];
        }
        return null;
    }

    public VWParticipant[] convertIdsToUserNamesPx(long[] userIds) throws VWException {
        this.checkSession();
        if (userIds == null || userIds.length < 0) {
            throw new VWException("vw.api.SConvertIdToUserNameIdNull", "convertIdsToUserNamesPx: User Id list is null");
        }
        VWParticipant[] result = this.getHashedParticipants(userIds);
        return result;
    }

    public VWSecurityDomain[] fetchSecurityDomains() throws VWException {
        this.checkSession();
        VWSecurityDomain[] domainList = this.cmdSession.fetchSecurityDomains();
        return domainList;
    }

    public VWParticipant[] fetchParticipantsPx(String secDomainName, String[] theNameList) throws VWException {
        return this.fetchParticipantsPx(secDomainName, theNameList, false);
    }

    protected VWParticipant[] fetchParticipantsPx(String secDomainName, String[] theNameList, boolean resolveUserId) throws VWException {
        VWParticipant[] result;
        this.checkSession();
        if (theNameList == null || theNameList.length < 1) {
            throw new VWException("vw.api.SfetchParticipantsPx", "fetchParticipantsPx: parameter theNameList is null");
        }
        long rpcArgBitMask = 65537L;
        if (resolveUserId) {
            rpcArgBitMask |= 0x20000L;
        }
        if ((result = this.cmdSession.fetchParticipants(secDomainName, theNameList, rpcArgBitMask)) != null && resolveUserId) {
            for (int i = 0; i < result.length; ++i) {
                if (result[i].getCommandSession() == null) {
                    result[i].setCommandSession(this.cmdSession);
                }
                result[i].getUserId(true);
            }
        }
        return result;
    }

    public boolean isMemberOfGroupByDomain(String domainName, String groupName) throws VWException {
        if (groupName == null || groupName.length() == 0) {
            throw new VWException("vw.api.SInvalidGroupName", "The group name is null or empty.");
        }
        this.checkSession();
        long rpcArgBitMask = 65537L;
        boolean isMemberOfGroup = this.cmdSession.isMemberOfGroup(groupName, domainName, rpcArgBitMask);
        return isMemberOfGroup;
    }

    public long getCurrentUserSecId() throws VWException {
        this.checkSession();
        return this.cmdSession.getSecurityId();
    }

    protected void finalize() {
        try {
            this.logoff();
        }
        catch (Exception e) {
            Object var1_2 = null;
        }
    }

    private VWParticipant[] getHashedParticipants(long[] userIds) throws VWException {
        VWParticipant[] participants = null;
        try {
            int unFoundItems;
            if (this.participantHashtable == null) {
                this.participantHashtable = new Hashtable();
            }
            int sz = 0;
            Vector<Long> unFindIds = new Vector<Long>();
            Vector<Integer> unFindIdsIndex = new Vector<Integer>();
            if (userIds != null) {
                sz = userIds.length;
                participants = new VWParticipant[sz];
                for (int i = 0; i < sz; ++i) {
                    if (userIds[i] != 9L) {
                        Long lKey = userIds[i];
                        participants[i] = (VWParticipant)this.participantHashtable.get(lKey);
                        if (participants[i] != null) continue;
                        unFindIds.add(userIds[i]);
                        unFindIdsIndex.add(i);
                        continue;
                    }
                    participants[i] = null;
                }
            }
            if ((unFoundItems = unFindIds.size()) > 0) {
                Object[] arrayOfIds = new Long[unFoundItems];
                unFindIds.copyInto(arrayOfIds);
                Object[] arrayOfIndexes = new Integer[unFoundItems];
                unFindIdsIndex.copyInto(arrayOfIndexes);
                VWParticipant[] colPx = this.cmdSession.convertSecurityIdstoNames((Long[])arrayOfIds);
                if (colPx == null || colPx.length != unFoundItems) {
                    throw new VWException("vw.api.VWsessionGetHashedParticipant", "failed to convert ids to names");
                }
                for (int k = 0; k < unFoundItems; ++k) {
                    int idx = (Integer)arrayOfIndexes[k];
                    participants[idx] = colPx[k];
                    if (participants[idx] == null) continue;
                    if (this.cmdSession.getSecurityType() < 1) {
                        String participantName = this.stripOrgAndDomain(participants[idx].getParticipantName());
                        participants[idx].setParticipantName(participantName);
                        participants[idx].setDisplayName(participantName);
                    }
                    this.participantHashtable.put(arrayOfIds[k], participants[idx]);
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("vw.api.VWsessionGetHashedParticipant", ex.getLocalizedMessage());
        }
        return participants;
    }

    public boolean fetchLimitApplicationFunctionalityFlag() throws VWException {
        return true;
    }

    protected IPECommands getCmdSession() throws VWException {
        this.checkSession();
        return this.cmdSession;
    }

    public void setBootstrapCEURI(String bootstrapCEURI) {
        this.m_bootstrapCEURI = bootstrapCEURI;
    }

    public void setBootstrapConfiguration(InputStream bootstrapConfigStream) {
        this.m_bootstrapConfigStream = bootstrapConfigStream;
    }

    private static final String getPrivilegedSystemProperty(String propName) {
        final String fpropName = propName;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fpropName);
            }
        });
    }

    private String formulateURLForBootstrap(String url) throws VWException {
        String m_method = "formulateURLForBootstrap:" + url;
        String res = url;
        String bypassCEURI = VWSession.getPrivilegedSystemProperty("filenet.pe.bypass.ceuri");
        boolean needCeURI = bypassCEURI == null || bypassCEURI.equals("false");
        try {
            new VWSOAPRouterURL(url);
            return url;
        }
        catch (Exception e) {
            try {
                new VWBootstrapURL(url);
                return url;
            }
            catch (Exception e2) {
                try {
                    if (needCeURI) {
                        if (this.m_bootstrapCEURI == null) {
                            this.m_bootstrapCEURI = VWSession.getPrivilegedSystemProperty("filenet.pe.bootstrap.ceuri");
                        }
                        if (this.m_bootstrapCEURI == null) {
                            this.m_bootstrapCEURI = Configuration.GetCEURI(this.m_bootstrapConfigStream, null);
                        }
                        if (this.m_bootstrapCEURI == null) {
                            throw new VWException("vw.api.sBootstrapCEURI.null", "The bootstrap CE URI is null. ");
                        }
                    }
                    res = VWBootstrapURL.GetBootstrapURI(this.m_bootstrapCEURI, url);
                }
                catch (VWException ex) {
                    throw ex;
                }
                catch (Exception e3) {
                    logger.throwing(m_className, m_method, e3);
                    VWException vwe = new VWException("vw.api.nobootstrap", "Failed to retrieve bootstrap information.");
                    vwe.setCause(e3);
                    throw vwe;
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, res);
                }
                return res;
            }
        }
    }

    public Locale[] fetchAvailableLocales() throws VWException {
        this.checkSession();
        String[] localeStrings = this.cmdSession.getAvailableLocales();
        Locale[] results = null;
        if (localeStrings != null && localeStrings.length > 0) {
            int nItems = localeStrings.length;
            results = new Locale[nItems];
            for (int i = 0; i < nItems; ++i) {
                results[i] = VWLocale.parseLocale(localeStrings[i]);
            }
        }
        return results;
    }

    public Locale fetchServerLocale() throws VWException {
        this.checkSession();
        String sloc = this.cmdSession.getServerLocale();
        if (sloc == null || sloc.length() < 2) {
            return null;
        }
        Locale ret = VWLocale.parseLocale(sloc);
        return ret;
    }

    public void setClientLocale(Locale myLocale) throws VWException {
        this.checkSession();
        this.cmdSession.setClientLocale(myLocale);
        UserContextInfo.get().setLocale(myLocale);
        if (logger.isFinest()) {
            logger.finest(m_className, "setClientLocale", myLocale == null ? "Default" : myLocale.toString());
        }
    }

    public Locale getClientLocale() throws VWException {
        this.checkSession();
        return this.cmdSession.getClientLocale();
    }

    protected String translate(String inStr) throws VWException {
        this.checkSession();
        return this.cmdSession.translate(inStr);
    }

    protected String[] translateStrArray(String[] inArray) throws VWException {
        this.checkSession();
        if (inArray != null && inArray.length > 0) {
            String[] translateArray = new String[inArray.length];
            try {
                for (int i = 0; i < inArray.length; ++i) {
                    translateArray[i] = this.cmdSession.translate(inArray[i]);
                }
                return translateArray;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return inArray;
    }

    protected String translateToAuthored(String inStr) throws VWException {
        this.checkSession();
        return this.cmdSession.translateToAuthored(inStr);
    }

    private boolean isAttachmentTrackingEnabled() {
        try {
            VWSystemConfiguration sysConfig = this.fetchSystemConfiguration();
            if (sysConfig != null) {
                return sysConfig.getTrackAttachmentReferences();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public VWRole[] fetchMyRoles(String appSpaceName) throws VWException {
        this.checkSession();
        VWRole[] res = this.cmdSession.fetchMyRoles(this.userName, this.translateToAuthored(appSpaceName));
        int nRoles = res == null ? 0 : res.length;
        for (int i = 0; i < nRoles; ++i) {
            res[i].setVWSession(this);
        }
        return res;
    }

    public VWRole fetchMyRole(String roleName, String appSpaceName) throws VWException {
        this.checkSession();
        VWRole res = this.cmdSession.fetchMyRole(this.translateToAuthored(roleName), this.translateToAuthored(appSpaceName));
        if (res != null) {
            res.setVWSession(this);
        }
        return res;
    }

    public int fetchPrivileges() throws VWException {
        this.checkSession();
        return this.cmdSession.fetchPrivileges();
    }

    public VWRole fetchRole(String appSpaceName, String roleName) throws VWException {
        this.checkSession();
        VWRole[] roleArr = this.cmdSession.fetchRoles(this.translateToAuthored(appSpaceName), new String[]{this.translateToAuthored(roleName)});
        if (roleArr != null && roleArr.length > 0) {
            roleArr[0].setVWSession(this);
            roleArr[0].refreshParticipants();
            return roleArr[0];
        }
        return null;
    }

    public String[] fetchAppSpaceNames(boolean ignoreSecurity) throws VWException {
        this.checkSession();
        return this.translateStrArray(this.cmdSession.fetchAppSpaceNames(ignoreSecurity));
    }

    public String[] fetchRoleNames(String appSpaceName, int accessFlag) throws VWException {
        this.checkSession();
        return this.translateStrArray(this.cmdSession.fetchRoleNames(accessFlag, this.translateToAuthored(appSpaceName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWStepElement createLaunchStepElement(String[] fieldNames, Object[] fieldValues, String workflowIdentifier) throws VWException {
        String m_method = "createLaunchStepElement:" + workflowIdentifier;
        VWTimerLog timer = new VWTimerLog("VWSession." + m_method);
        VWStepElement result = null;
        try {
            if (workflowIdentifier == null || workflowIdentifier.length() == 0) {
                throw new VWException("vw.api.SWorkflowIdentifierNullInCreateLiveWorkObject", "The workflowIdentifier is null or empty.");
            }
            this.checkSession();
            boolean returnWobNum = true;
            VWField[] theFields = this.cmdSession.createLaunchStepElement(fieldNames, fieldValues, this.translateToAuthored(workflowIdentifier), 1, returnWobNum);
            if (theFields != null) {
                result = new VWStepElement(theFields, this, returnWobNum, fieldNames, fieldValues);
            }
            VWStepElement vWStepElement = result;
            return vWStepElement;
        }
        finally {
            logger.exiting(m_className, m_method);
            timer.stop();
        }
    }

    protected void updateConfig() {
        try {
            if (this.cmdSession != null) {
                this.cmdSession.getConfigInfo(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public VWApplicationSpace[] fetchApplicationSpaces(int nFetchFlag) throws VWException {
        if (nFetchFlag < 0 || nFetchFlag > 2) {
            throw new VWException("vw.api.VWSession.invalidApplicationSpaceFetchFlag", "An invalid field value was specified. The value \"{0}\" does not correspond to one of the available VWSession field values for application spaces. /nSpecify a valid VWSession field value.", nFetchFlag);
        }
        this.checkSession();
        VWApplicationSpace[] res = this.cmdSession.fetchApplicationSpaces(null, nFetchFlag);
        if (res != null) {
            for (int i = 0; i < res.length; ++i) {
                if (res[i] == null) continue;
                res[i].setVWSession(this);
            }
        }
        return res;
    }

    public VWApplicationSpace fetchApplicationSpace(String appSpaceName, int nFetchFlag) throws VWException {
        if (nFetchFlag < 0 || nFetchFlag > 2) {
            throw new VWException("vw.api.VWSession.invalidApplicationSpaceFetchFlag", "An invalid field value was specified. The value \"{0}\" does not correspond to one of the available VWSession field values for application spaces. /nSpecify a valid VWSession field value.", nFetchFlag);
        }
        if (appSpaceName == null || appSpaceName.length() == 0) {
            throw new VWException("vw.api.VWSession.invalidApplicationSpaceNameIsNullOrEmpty", "An empty or null appspace name is not allowed.");
        }
        this.checkSession();
        String[] appSpaceNames = new String[]{this.translateToAuthored(appSpaceName)};
        VWApplicationSpace[] res = this.cmdSession.fetchApplicationSpaces(appSpaceNames, nFetchFlag);
        if (res != null && res.length > 0 && res[0] != null) {
            res[0].setVWSession(this);
            return res[0];
        }
        return null;
    }

    protected boolean verifyCreds() throws VWException {
        this.checkSession();
        return this.cmdSession.verifyCreds();
    }

    public String getObjectStoreSymbolicName() throws VWException {
        this.checkSession();
        VWGuid tmpObjectStoreId = this.cmdSession.getObjectStoreId();
        if (tmpObjectStoreId == null || !tmpObjectStoreId.equals(this.objectStoreId) || this.objectStoreSymbolicName == null) {
            this.objectStoreSymbolicName = null;
            if (tmpObjectStoreId != null) {
                this.objectStoreSymbolicName = this.cmdSession.fetchObjectStoreSymbolicName(tmpObjectStoreId);
            }
            this.objectStoreId = tmpObjectStoreId;
        }
        return this.objectStoreSymbolicName;
    }

    public VWGuid getObjectStoreId() throws VWException {
        this.checkSession();
        VWGuid tmpObjectStoreId = this.cmdSession.getObjectStoreId();
        if (tmpObjectStoreId == null || !tmpObjectStoreId.equals(this.objectStoreId)) {
            this.objectStoreSymbolicName = null;
            this.objectStoreId = tmpObjectStoreId;
        }
        return this.objectStoreId;
    }

    static {
        try {
            XMLHelper.parseDocumentViaDOM(null, null, null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final class VWMailAuthenticationConvertTwo
    extends VWConvertTwo {
        int KEY_MASK = 0;

        protected VWMailAuthenticationConvertTwo(int mask) {
            this.KEY_MASK = mask;
        }

        protected String getKey(int id) {
            return "MIIBCTCBtAIBADBPMQswCQYDeQQGEwJV6s4fUzEQMA4GA1UECBMHRmxvcmlkYTEYMBYGA1UEChMPRXllcyBvbiBUaGUgV2ViMRQwEgYDVQQDFAt3d3cuZXR3Lm5ldDBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCeojtjnHqg0GTxp+XZ56RaSe1iZWpumXjU6Sx7v1FdXzsY1oLOQa090Jtnu1WsQRHh0yDS+45oncjKm1zCIZAgMBAAGgADANBgkqhkiG9w0BAQQFAANBAFBj9g+NiUh8YWPrFGntgf4miUdwqUshptjJy4PjdsD*3ugy5avvuh3GPpGh2aYXIjHpJXTUBQyzxSEIINYtc";
        }

        protected String getEString(String name, String password) throws Exception {
            return super.getEString(name, password);
        }

        protected VWAuthItem getDString(String token) throws Exception {
            return super.getDString(token);
        }
    }
}

